define([
    'backbone',
    'marionette',
    'modules/page/popup/external-nav-popup-view',
],
function (Backbone, Marionette, ExternalNavigationWarningPopup) {
    'use strict';

    return Marionette.Behavior.extend({
        events: {'click .external-link': 'openExternalLink'},
        openExternalLink: function(e) {
            var navigationWarning;
            e.preventDefault();

            navigationWarning = new ExternalNavigationWarningPopup({
                elAfterClose: e.currentTarget,
                model: new Backbone.Model({href: $(e.currentTarget).attr('href')}),
            });
            navigationWarning.openPopup();
        },
    });
});
